<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Audio_Quiz_Leaderboard;
use App\Models\Avatar;
use App\Models\Badge;
use App\Models\Coin_Share_List;
use App\Models\Common;
use App\Models\Contest_Leaderboard;
use App\Models\Daily_Quiz_Leaderboard;
use App\Models\Exam_Leaderboard;
use App\Models\Fear_Factor_Quiz_Leaderboard;
use App\Models\Normal_Quiz_Leaderboard;
use App\Models\Pratice_Quiz_Leaderboard;
use App\Models\Refer_Earn;
use App\Models\Smtp_Setting;
use App\Models\Transaction;
use App\Models\True_False_Quiz_Leaderboard;
use App\Models\Ultimate_Challenge_Leaderboard;
use App\Models\User;
use App\Models\User_Badge_List;
use App\Models\Video_Quiz_Leaderboard;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Exception;
use Illuminate\Support\Facades\Mail;
use Illuminate\Validation\Rule;

// Login Type : 1- OTP, 2- Google, 3- Apple, 4- Normal
class UserController extends Controller
{
    private $folder = "user";
    private $folder_badge = "badge";
    private $folder_avatar = "avatar";
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function registration(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'full_name' => 'required|min:2',
                'email' => [
                    'required',
                    'email',
                    Rule::unique('tbl_user')->where(function ($query) {
                        return $query->where('is_account_verify', 1);
                    }),
                ],
                'password' => 'required|min:4',
                'reference_code' => 'nullable|exists:tbl_user,reference_code',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $existing = User::where('email', $request['email'])->where('is_account_verify', 0)->first();
            if ($existing) {
                $existing->delete();
            }

            $user = new User();
            $email_array = explode('@', $request['email']);
            $user['user_name'] = $this->common->user_name($email_array[0]);
            $user['full_name'] = $request['full_name'];
            $user['email'] = $request['email'];
            $user['password'] = Hash::make($request['password']);
            $user['country_code'] = "";
            $user['mobile_number'] = "";
            $user['country_name'] = "";
            $user['type'] = 4;
            $user['image_type'] = 1;
            $user['image'] = "";
            $user['bio'] = $this->common->user_bio();
            $user['reference_code'] = $this->common->generateReferralCode(6);
            $user['wallet_coin'] = 0;
            $user['device_type'] = $request['device_type'] ?? 0;
            $user['device_token'] = $request['device_token'] ?? "";
            $user['qr_code'] = '';
            $user['is_account_verify'] = 0;
            $user['status'] = 1;

            if ($user->save()) {

                if (filled($request['reference_code'])) {
                    $parent = User::where('reference_code', $request['reference_code'])->first();
                    $setting = Setting_Data();

                    Refer_Earn::create([
                        'parent_user_id' => $parent['id'],
                        'child_user_id' => $user['id'],
                        'reference_code' => $request['reference_code'],
                        'parent_user_coin' => $setting['parent_user_earn'] ?? 0,
                        'child_user_coin' => $setting['child_user_earn'] ?? 0,
                        'status' => 1,
                    ]);

                    $parent->wallet_coin += $setting['parent_user_earn'] ?? 0;
                    $parent->save();

                    $user->wallet_coin += $setting['child_user_earn'] ?? 0;
                    $user->save();
                }

                $user['qr_code'] = $this->common->create_qr_code($user['id']);
                $user->save();

                // Send Verify Mail
                $this->common->send_verify_mail($user['id'], $user['email']);

                $user['image'] = $this->common->getImage($this->folder, $user['image']);
                return $this->common->API_Response(200, __('api_msg.verification_email_sent_successfully'));
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function verify_email(Request $request, $id, $email)
    {
        if (!$request->hasValidSignature()) {
            return response('Link expired or invalid.', 403);
        }

        $user = User::where('id', $id)->where('email', $email)->first();
        if (!$user) {
            return response('User not found.', 404);
        }
        if ($user['is_account_verify'] == 1) {
            return response('Your Email is Already Verified.');
        }

        // Update user as verified
        $user['is_account_verify'] = 1;
        $user->save();

        return response('Your Email has been Successfully Verified!');
    }
    public function forgot_password(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'email' => [
                    'required',
                    'email',
                    Rule::exists('tbl_user', 'email')->where(fn($q) => $q->where('is_account_verify', 1)->where('type', 4)),
                ],
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user = User::where('email', $request['email'])->first();
            $smtp = Smtp_Setting::latest()->first();
            if ($smtp && $smtp['status'] == 1) {

                $new_pw = $this->common->forgot_password(6);

                $user['password'] = Hash::make($new_pw);
                $user->save();

                $this->common->SetSmtpConfig();

                $details = [
                    'title' => App_Name() . ' - Password Reset',
                    'body' => "Hi <span style='color: #4e45b8'>{$user['user_name']}</span>, Your New Password is: <strong style='color: #4e45b8'>{$new_pw}</strong><br><br>Please change it after login for security.",
                ];
                Mail::to($user['email'])->send(new \App\Mail\mail($details, 'mail.forgot'));
            }
            return $this->common->API_Response(200, __('api_msg.a_new_password_has_been_sent_to_your_email'));
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function login(Request $request)
    {
        try {
            if ($request['type'] == 1) {

                $validation = Validator::make($request->all(), [
                    'country_code' => 'required',
                    'mobile_number' => 'required|numeric',
                    'country_name' => 'required',
                    'reference_code' => 'nullable|exists:tbl_user,reference_code',
                ]);
            } elseif ($request['type'] == 2 || $request['type'] == 3) {

                $validation = Validator::make($request->all(), [
                    'email' => 'required',
                    'reference_code' => 'nullable|exists:tbl_user,reference_code',
                ]);
            } elseif ($request['type'] == 4) {

                $validation = Validator::make($request->all(), [
                    'email' => 'required|email',
                    'password' => 'required|min:4',
                    'reference_code' => 'nullable|exists:tbl_user,reference_code',
                ]);
            } else {

                $validation = Validator::make($request->all(), [
                    'type' => 'required|numeric',
                ]);
            }
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $type = $request['type'] ?? 0;
            $full_name = $request['full_name'] ?? '';
            $email = $request['email'] ?? '';
            $country_code = $request['country_code'] ?? '';
            $mobile_number = $request['mobile_number'] ?? '';
            $country_name = $request['country_name'] ?? '';
            $device_type = $request['device_type'] ?? 0;
            $device_token = $request['device_token'] ?? '';
            $image = '';
            if (isset($request['image']) && $request['image'] != null) {

                $file = $request->file('image');
                $image = $this->common->saveImage($file, $this->folder, 'user_');
            }

            // OTP
            if ($type == 1) {

                $user = User::where('country_code', $country_code)->where('mobile_number', $mobile_number)->where('type', $type)->first();
                if (isset($user) && $user != null) {

                    $user->update([
                        'device_token' => $device_token,
                        'device_type' => $device_type,
                    ]);
                    $user['device_token'] = $device_token;
                    $user['device_type'] = $device_type;

                    $this->common->userImage([$user]);

                    return $this->common->API_Response(200, __('api_msg.login_successfully'), [$user]);
                } else {

                    $user = new User();
                    $user['user_name'] = $this->common->user_name($mobile_number);
                    $user['full_name'] = $full_name;
                    $user['email'] = "";
                    $user['password'] = "";
                    $user['country_code'] = $country_code;
                    $user['mobile_number'] = $mobile_number;
                    $user['country_name'] = $country_name;
                    $user['type'] = $type;
                    $user['image_type'] = 1;
                    $user['image'] = $image;
                    $user['bio'] = $this->common->user_bio();
                    $user['reference_code'] = $this->common->generateReferralCode(6);
                    $user['wallet_coin'] = 0;
                    $user['device_type'] = $device_type;
                    $user['device_token'] = $device_token;
                    $user['qr_code'] = "";
                    $user['is_account_verify'] = 0;
                    $user['status'] = 1;
                    if ($user->save()) {

                        if (filled($request['reference_code'])) {
                            $parent = User::where('reference_code', $request['reference_code'])->first();
                            $setting = Setting_Data();

                            Refer_Earn::create([
                                'parent_user_id' => $parent['id'],
                                'child_user_id' => $user['id'],
                                'reference_code' => $request['reference_code'],
                                'parent_user_coin' => $setting['parent_user_earn'] ?? 0,
                                'child_user_coin' => $setting['child_user_earn'] ?? 0,
                                'status' => 1,
                            ]);

                            $parent['wallet_coin'] += $setting['parent_user_earn'] ?? 0;
                            $parent->save();

                            $user['wallet_coin'] += $setting['child_user_earn'] ?? 0;
                            $user->save();
                        }

                        $user['qr_code'] = $this->common->create_qr_code($user['id']);
                        $user->save();

                        $user['image'] = $this->common->getImage($this->folder, $user['image']);
                        return $this->common->API_Response(200, __('api_msg.login_successfully'), [$user]);
                    } else {
                        return $this->common->API_Response(400, __('api_msg.data_not_save'));
                    }
                }
            }

            // Google || Apple
            if ($type == 2 || $type == 3) {

                $user = User::where('email', $email)->where('type', $type)->first();
                if (isset($user) && $user != null) {

                    $user->update([
                        'device_token' => $device_token,
                        'device_type' => $device_type,
                    ]);
                    $user['device_token'] = $device_token;
                    $user['device_type'] = $device_type;

                    $this->common->userImage([$user]);

                    return $this->common->API_Response(200, __('api_msg.login_successfully'), [$user]);
                } else {

                    $user = new User();
                    $email_array = explode('@', $email);
                    $user['user_name'] = $this->common->user_name($email_array[0]);
                    $user['full_name'] = $full_name;
                    $user['email'] = $email;
                    $user['password'] = "";
                    $user['country_code'] = "";
                    $user['mobile_number'] = "";
                    $user['country_name'] = "";
                    $user['type'] = $type;
                    $user['image_type'] = 1;
                    $user['image'] = $image;
                    $user['bio'] = $this->common->user_bio();
                    $user['reference_code'] = $this->common->generateReferralCode(6);
                    $user['wallet_coin'] = 0;
                    $user['device_type'] = $device_type;
                    $user['device_token'] = $device_token;
                    $user['qr_code'] = "";
                    $user['is_account_verify'] = 0;
                    $user['status'] = 1;
                    if ($user->save()) {

                        if (filled($request['reference_code'])) {
                            $parent = User::where('reference_code', $request['reference_code'])->first();
                            $setting = Setting_Data();

                            Refer_Earn::create([
                                'parent_user_id' => $parent['id'],
                                'child_user_id' => $user['id'],
                                'reference_code' => $request['reference_code'],
                                'parent_user_coin' => $setting['parent_user_earn'] ?? 0,
                                'child_user_coin' => $setting['child_user_earn'] ?? 0,
                                'status' => 1,
                            ]);

                            $parent['wallet_coin'] += $setting['parent_user_earn'] ?? 0;
                            $parent->save();

                            $user['wallet_coin'] += $setting['child_user_earn'] ?? 0;
                            $user->save();
                        }

                        $user['qr_code'] = $this->common->create_qr_code($user['id']);
                        $user->save();

                        $user['image'] = $this->common->getImage($this->folder, $user['image']);
                        return $this->common->API_Response(200, __('api_msg.login_successfully'), [$user]);
                    } else {
                        return $this->common->API_Response(400, __('api_msg.data_not_save'));
                    }
                }
            }

            // Normal
            if ($type == 4) {

                $user = User::where('email', $email)->where('type', $type)->first();
                if (isset($user) && $user != null) {

                    if ($user['is_account_verify'] == 0) {
                        return $this->common->API_Response(400, __('api_msg.verify_your_email'));
                    }

                    if (Hash::check($request['password'], $user['password'])) {

                        $user->update([
                            'device_token' => $device_token,
                            'device_type' => $device_type,
                        ]);
                        $user['device_token'] = $device_token;
                        $user['device_type'] = $device_type;

                        $this->common->userImage([$user]);

                        return $this->common->API_Response(200, __('api_msg.login_successfully'), [$user]);
                    } else {
                        return $this->common->API_Response(400, __('api_msg.email_pass_worng'));
                    }
                } else {
                    return $this->common->API_Response(400, __('api_msg.email_pass_worng'));
                }
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_profile(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $data = User::where('id', $request['user_id'])->first();
            if ($data) {

                $this->common->userImage([$data]);
                $data['qr_code'] = $this->common->getFile($this->folder, $data['qr_code']);

                return $this->common->API_Response(200, __('api_msg.data_retrieved'), [$data]);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function update_profile(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $data = User::where('id', $request['user_id'])->first();
            if ($data) {

                if (isset($request['user_name']) && $request['user_name'] != '') {

                    $check = User::where('user_name', $request['user_name'])->first();
                    if ($check) {

                        if ($check['id'] == $data['id']) {
                            $data['user_name'] = $request['user_name'];
                        } else {
                            return $this->common->API_Response(400, __('api_msg.user_name_exists'));
                        }
                    } else {
                        $data['user_name'] = $request['user_name'];
                    }
                }
                if (isset($request['full_name']) && $request['full_name'] != '') {
                    $data['full_name'] = $request['full_name'];
                }
                if (isset($request['bio']) && $request['bio'] != '') {
                    $data['bio'] = $request['bio'];
                }
                if (isset($request['image_type']) && $request['image_type'] != '') {
                    if ($request['image_type'] == 1) {

                        if ($request->file('image')) {

                            $data['image_type'] = $request['image_type'];
                            $file = $request['image'];
                            $old_image = $data['image'];

                            $data['image'] = $this->common->saveImage($file, $this->folder, 'user_');

                            $this->common->deleteImageToFolder($this->folder, $old_image);
                        }
                    } else if ($request['image_type'] == 2) {

                        $this->common->deleteImageToFolder($this->folder, $data['image']);

                        $data['image_type'] = $request['image_type'];
                        $data['image'] = $request['image'];
                    }
                }
                $data->save();

                $this->common->userImage([$data]);

                return $this->common->API_Response(200, __('api_msg.profile_updated'), [$data]);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_badge_list(Request $request)
    {
        try {
            $user_id = $request['user_id'] ?? 0;

            $data = Badge::where('status', 1)->get();
            if (count($data)) {

                for ($i = 0; $i < count($data); $i++) {

                    $data[$i]['image'] = $this->common->getImage($this->folder_badge, $data[$i]['image']);
                    $data[$i]['is_user_win'] = $this->common->is_badge_win($user_id, $data[$i]['id']);
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_user_badge(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $data = User_Badge_List::where('user_id', $request['user_id'])->with('badge')->latest()->get();
            if (count($data)) {

                $badge = [];
                for ($i = 0; $i < count($data); $i++) {

                    if ($data[$i]['badge'] != null) {

                        $data[$i]['badge']['user_winning_coin'] = $data[$i]['coin'];
                        $data[$i]['badge']['image'] = $this->common->getImage($this->folder_badge, $data[$i]['badge']['image']);

                        $badge[] = $data[$i]['badge'];
                    }
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $badge);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_avatar()
    {
        try {

            $data = Avatar::where('status', 1)->orderBy('sort_order', 'asc')->latest()->get();
            if ($data) {

                $this->common->imageNameToUrl($data, 'image', $this->folder_avatar);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_badge(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];

            $user_badge_ids = User_Badge_List::where('user_id', $user_id)->pluck('badge_id')->toArray();
            $data = Badge::whereNotIn('id', $user_badge_ids)->where('status', 1)->get();
            if (count($data)) {

                $badge = [];
                for ($i = 0; $i < count($data); $i++) {

                    if ($data[$i]['id'] == 1 && $data[$i]['status'] == 1) { // Practice
                        $query_total = Pratice_Quiz_Leaderboard::where('user_id', $user_id)->where('status', 1)->count();
                        $badge_total = $data[$i]['min_pass_quiz'];
                    }
                    if ($data[$i]['id'] == 2 && $data[$i]['status'] == 1) { // Normal
                        $query_total = Normal_Quiz_Leaderboard::where('user_id', $user_id)->where('status', 1)->count();
                        $badge_total = $data[$i]['min_pass_quiz'];
                    }
                    if ($data[$i]['id'] == 3 && $data[$i]['status'] == 1) { // Audio
                        $query_total = Audio_Quiz_Leaderboard::where('user_id', $user_id)->where('status', 1)->count();
                        $badge_total = $data[$i]['min_pass_quiz'];
                    }
                    if ($data[$i]['id'] == 4 && $data[$i]['status'] == 1) { // Video
                        $query_total = Video_Quiz_Leaderboard::where('user_id', $user_id)->where('status', 1)->count();
                        $badge_total = $data[$i]['min_pass_quiz'];
                    }
                    if ($data[$i]['id'] == 5 && $data[$i]['status'] == 1) { // True-False
                        $query_total = True_False_Quiz_Leaderboard::where('user_id', $user_id)->where('status', 1)->count();
                        $badge_total = $data[$i]['min_pass_quiz'];
                    }
                    if ($data[$i]['id'] == 6 && $data[$i]['status'] == 1) { // Fear-Factor
                        $query_total = Fear_Factor_Quiz_Leaderboard::where('user_id', $user_id)->where('status', 1)->count();
                        $badge_total = $data[$i]['min_pass_quiz'];
                    }
                    if ($data[$i]['id'] == 8 && $data[$i]['status'] == 1) { // Ultimate Challange
                        $query_total = Ultimate_Challenge_Leaderboard::where('user_id', $user_id)->where('status', 1)->count();
                        $badge_total = $data[$i]['min_pass_quiz'];
                    }
                    if ($data[$i]['id'] == 9 && $data[$i]['status'] == 1) { // Contest
                        $query_total = Contest_Leaderboard::where('user_id', $user_id)->where('rank', '!=', 0)->where('winning_coin', '!=', 0)->where('status', 1)->count();
                        $badge_total = $data[$i]['min_win_contest'];
                    }
                    if ($data[$i]['id'] == 10 && $data[$i]['status'] == 1) { // Daily Quiz
                        $query_total = Daily_Quiz_Leaderboard::where('user_id', $user_id)->where('status', 1)->count();
                        $badge_total = $data[$i]['min_day_play'];
                    }
                    if ($data[$i]['id'] == 11 && $data[$i]['status'] == 1) { // Coin Sharing
                        $query_total = Coin_Share_List::where('user_id', $user_id)->sum('coin');
                        $badge_total = $data[$i]['min_coin_sharing'];
                    }
                    if ($data[$i]['id'] == 12 && $data[$i]['status'] == 1) { // Subscription
                        $query_total = Transaction::where('user_id', $user_id)->count();
                        $badge_total = 1;
                    }
                    if ($data[$i]['id'] == 13 && $data[$i]['status'] == 1) { // Refer Earn
                        $query_total = Refer_Earn::where('parent_user_id', $user_id)->where('status', 1)->count();
                        $badge_total = $data[$i]['min_referrals'];
                    }
                    if ($data[$i]['id'] == 15 && $data[$i]['status'] == 1) { // Exam
                        $query_total = Exam_Leaderboard::where('user_id', $user_id)->where('status', 1)->count();
                        $badge_total = $data[$i]['min_pass_quiz'];
                    }

                    if ($query_total >= $badge_total) {

                        $insert = new User_Badge_List();
                        $insert['user_id'] = $user_id;
                        $insert['badge_id'] = $data[$i]['id'];
                        $insert['coin'] = $data[$i]['earning_coin'];
                        $insert['status'] = 1;
                        $insert->save();

                        $data[$i]['image'] = $this->common->getImage($this->folder_badge, $data[$i]['image']);
                        $badge[] = $data[$i];

                        User::where('id', $user_id)->increment('wallet_coin', $data[$i]['earning_coin']);
                    }
                }

                if (count($badge) > 0) {
                    return $this->common->API_Response(200, __('api_msg.data_retrieved'), $badge);
                } else {
                    return $this->common->API_Response(400, __('api_msg.data_not_found'));
                }
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function coin_sharing(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'to_user_id' => 'required|numeric',
                'coin' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $to_user_id = $request['to_user_id'];
            $coin = $request['coin'];

            $user = User::find($user_id);
            if (!$user || $user['wallet_coin'] < $coin) {
                return $this->common->API_Response(400, __('api_msg.insufficient_balance'));
            }

            Coin_Share_List::create([
                'user_id' => $user_id,
                'to_user_id' => $to_user_id,
                'coin' => $coin,
                'status' => 1,
            ]);
            $user->decrement('wallet_coin', $coin);
            User::where('id', $to_user_id)->increment('wallet_coin', $coin);

            return $this->common->API_Response(200, __('api_msg.coin_sharing'), []);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
}
